// KEY
//Debounce definitions
#define KEY_DDR     DDRD
#define KEY_PIN     PIND
#define KEY_PORT     PORTD

#define BTN_UP      4  
#define BTN_DN      3
#define BTN_LT      2
#define BTN_RT      5
#define BTN_EN      6
#define BTN_MD      0
#define BTN_ES      1

#define KEY_MSK     (1<<BTN_UP | 1<<BTN_DN | 1<<BTN_LT | 1<<BTN_RT | 1<<BTN_EN | 1<<BTN_MD | 1<<BTN_ES)
volatile unsigned char key_press;
//Debounce
//unsigned char debounce_cnt = 0;
unsigned char key_state;

unsigned char get_key_press(unsigned char key_mask)
{
  #asm("cli")
  key_mask &= key_press;                        // read key(s)
  key_press ^= key_mask;                        // clear key(s)
  #asm("sei")
  return key_mask;
}

void Key_init(void){
KEY_DDR=~KEY_MSK;
KEY_PORT=KEY_MSK;

}